'''
Name: srd_projections.py

Overview: Provides classes for obtaining spatial reference objects.

Description:
    To obtain a spatial reference object create an instance of the
    SRD_Projection class and call the appropriate method to return
    the spatial refernce of interest.

    Examples:

    from srd.srd_projections import *
    
    srObj = SRD_Projection()

    srUTM11 = srObj.UTM11()
    srUTM11 = srObj.UTM12()
    srTTM = srObj.TTM()
    srGeo = srObj.Geographic()
    srGeo = srObj.GeographicWGS84()
    
    
Notes:
    This module is no longer needed because of ease of defining
    projection in 10.1. Has bee kept to support existing applications.

Author: Doug Crane
        May, 2012

Modifications:
    Sept 2012, Upgraded to 10.1

'''

__author__ = 'Doug Crane'
__version__ = '1.0'

import sys
import os
import pdb

import arcpy

from srd_exception import *

__all__ = ['SRD_Projection']

# ====================================================================
class SRD_Projection(object):

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def UTM11(self):
        '''
        Return the UTM 11 spatial reference.

        '''

        return arcpy.SpatialReference('NAD 1983 UTM Zone 11N')    
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def UTM12(self):
        '''
        Return the UTM 12 spatial reference.

        '''

        return arcpy.SpatialReference('NAD 1983 UTM Zone 12N')
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def TTM(self):
        '''
        Return the TTM spatial reference.

        '''

        return arcpy.SpatialReference('NAD 1983 10TM AEP Forest')
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def Geographic(self):
        '''
        Return the Geographic spatial reference.

        '''

        return arcpy.SpatialReference('NAD 1983')
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def GeographicWGS84(self):
        '''
        Return the Geographic WGS84 spatial reference.

        '''

        return arcpy.SpatialReference('WGS 1984')
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~        
if __name__ == '__main__':

    try:

        myObj = SRD_Projection()

        sr = myObj.GeographicWGS84()

        pdb.set_trace()
        
    except SRD_Exception as e:
        print e.errMsg
        arcpy.AddError(e.errMsg)
