'''
Name: srd_exception.py

Overview: Provides basic class for handling SRD Utility exceptions

Description/Example:

    from srd_exception import *
    import srd.srd_misc as srd_misc
    
Example for setting:
        

    raise SRD_Exception('Feature class: %s not found' % featureClass)
        
Example for capture (assumes you have set log file as logChn):

        except SRD_Exception as e:
            logChn.logError(e)
            logChn.logError(srd_misc.exceptionDetails(sys.exc_info()[2]))
    
Notes:

Author: Doug Crane
        May, 2012

Modifications:

'''

__author__ = 'Doug Crane'
__version__ = '1.0'

import sys
import traceback
import arcpy

__all__ = ['SRD_Exception']

# ====================================================================
class SRD_Exception(Exception):
    '''
    '''
    def __init__(self, errMsgArg):
        self.errMsg = '\n***\n*** ERROR:\n %s\n*** ' % errMsgArg
    def __str__(self):
         return self.errMsg
        
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~        
if __name__ == '__main__':

    import srd.srd_misc as srd_misc
    import srd.srd_logging as srd_logging

        
    logChn = srd_logging.SRD_Log()

        
