'''
Name: avi_forest_covertool.py

Overview: 

Description:
    
Notes:

Author: Doug Crane
        Apr, 2011

Modifications:

'''

logChn = None

import pdb
import os
import sys
import datetime

import arcpy

from srd.srd_exception import *
import srd.srd_logging as srd_logging
import srd.srd_misc as srd_misc

from avi_tpr import *

DEBUG = 0
#--------------------------------------------------------------------------
if __name__ == '__main__':

    arcpy.env.overwriteOutput = True
    # If using geographic features then may be best to modify these.
    arcpy.env.XYTolerance = .001
    arcpy.env.XYResolution = .0001
    arcpy.gp.logHistory = False

    if DEBUG:
        # Modify arguments to simulate those passed from toolbox.
        # You will have to modify these based on your scripts requirements.
        sys.argv = [sys.argv[0], \
        r'D:\test Data\TPR\aviTest.gdb\avi1']
        print('\n***\n*** IN DEBUG MODE\n***')
        arcpy.AddMessage('\n***\n*** IN DEBUG MODE\n***')
        
    try:

        logFilePath = srd_misc.getLogFilePath(sys.argv[0])
        logChn = srd_logging.SRD_Log(logFilePath)

        #-------------------------------------------------------------
        # Set the log file.
        if logFilePath:
            try:
                # Parameters to tool will be written to log file in case of problems.
                params = arcpy.GetParameterInfo()
                hdrList = ['Arguments:']
                for param in params:
                    hdrList.append('Name: %s, Type: %s, Value: %s' % (param.name, param.parameterType, param.value))
                logChn.stampHeader(hdrList)
                arcpy.AddMessage('\n*** Log information will be written to: %s\n' % logFilePath)
                logChn.stampHeader(hdrList)
                arcpy.AddMessage('\n*** Log information will be written to: %s\n' % logFilePath)
            except:
                pass

        fcPathArg = arcpy.GetParameterAsText(0)

        selCnt = int(arcpy.GetCount_management(fcPathArg).getOutput(0))
        logChn.logWarning('\n***\n*** %s records selected for validation...\n***' % selCnt)
                                    
        aviObj = AVI_TPR()
        aviObj.validateTPR(fcPathArg)
        
    except SRD_Exception as e:
        if logChn:
            logChn.logError(e)
            logChn.logError(srd_misc.exceptionDetails(sys.exc_info()[2]))
        else:
            arcpy.AddMessage(srd_misc.exceptionDetails(sys.exc_info()[2]))
    except Exception as e:
        if logChn:
            logChn.logError(e)
            logChn.logError(srd_misc.exceptionDetails(sys.exc_info()[2]))
        else:
            arcpy.AddMessage(srd_misc.exceptionDetails(sys.exc_info()[2]))
    else:
        logChn.logMsg('\n*** %s completed normally\n' % sys.argv[0])
    finally:
        arcpy.ResetEnvironments()
        if logChn:
            logChn.closeLog()
